//
//  CSBugReporter.h
//
//  Created by Alastair Houghton on 08/10/2004.
//  Copyright 2004 Coriolis Systems Limited. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class CSMailClient;

typedef enum {
  CSBugFeatureRequest,
  CSBugMinorBug,
  CSBugMajorBug,
  CSBugCrashReport
} CSBugType;

@interface NSObject (BugReporterFinished)

- (void)bugReporterFinishedWithError:(NSError *)error;

@end

@interface CSBugReporter : NSObject {
  IBOutlet NSWindow *bugReportPanel;
  IBOutlet NSProgressIndicator *progressIndicator;
  IBOutlet NSView *emailContainer;

  NSString  *shortDescription;
  NSString  *fullDescription;
  NSString  *additionalInfo;
  NSString  *emailAddress;
  CSBugType reportType;
  BOOL	    omitSystemProfile;

  NSString  *currentStatus;
  BOOL	    busy;
  NSString  *saveName;

  NSString  *logPath;
  BOOL      canAbort;
  BOOL	    allowTimeToAbort;
  BOOL	    initialisedEmail;

  NSArray   *logFiles;
  NSBundle  *productBundle;

  unsigned  currentJob;
  CSMailClient *mailClient;
}

+ (CSBugReporter *)sharedBugReporter;

- (NSString *)currentStatus;

#define PROPERTY(x, type, getter, setter) \
  @property (x) type getter

PROPERTY (copy, NSString *, shortDescription, setShortDescription);
PROPERTY (copy, NSString *, fullDescription, setFullDescription);
PROPERTY (copy, NSString *, additionalInfo, setAdditionalInfo);
PROPERTY (copy, NSString *, emailAddress, setEmailAddress);
PROPERTY (copy, NSArray *, logFiles, setLogFiles);
PROPERTY (retain, NSBundle *, productBundle, setProductBundle);
PROPERTY (assign, BOOL, omitSystemProfile, setOmitSystemProfile);
PROPERTY (assign, BOOL, allowTimeToAbort, setAllowTimeToAbort);

#undef PROPERTY

- (CSBugType)reportType;

- (void)setCurrentStatus:(NSString *)status;
- (void)setShortDescription:(NSString *)shortDesc;
- (void)setFullDescription:(NSString *)fullDesc;
- (void)setReportType:(CSBugType)type;

- (BOOL)busy;
- (void)setBusy:(BOOL)b;

- (BOOL)windowShouldClose:(id)sender;

- (IBAction)save:(id)sender;
- (IBAction)send:(id)sender;
- (IBAction)abort:(id)sender;

- (void)showWindow;
- (void)doDefaultBugReport;

- (BOOL)redirectLogsTo:(NSString *)logFile;

- (BOOL)canAbort;

- (CSMailClient *)mailClient;
- (void)setMailClient:(CSMailClient *)mc;

@end

extern NSString * const CSBugReporterErrorDomain
  /* = @"CSBugReporterErrorDomain" */;

enum {
  CSBugReporterNoMailCientConfiguredError = 1
};
